//GEMINI-pro DATASET v1.0 Category: Bucket Sort Implementation ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE 100

void bucketSort(int arr[], int n) {
  int i, j;
  int count[MAX_SIZE];
  int output[MAX_SIZE];

  // Initialize the count array with zeros
  for (i = 0; i < MAX_SIZE; i++) {
    count[i] = 0;
  }

  // Store the count of each element in the count array
  for (i = 0; i < n; i++) {
    count[arr[i]]++;
  }

  // Change count[i] so that count[i] contains the actual
  // position of this element in the output[]
  for (i = 1; i < MAX_SIZE; i++) {
    count[i] += count[i - 1];
  }

  // Build the output array
  for (i = n - 1; i >= 0; i--) {
    output[count[arr[i]] - 1] = arr[i];
    count[arr[i]]--;
  }

  // Copy the output array to the input array
  for (i = 0; i < n; i++) {
    arr[i] = output[i];
  }
}

// Driver program to test the bucket sort
int main() {
  int arr[] = {1, 5, 3, 2, 4};
  int n = sizeof(arr) / sizeof(arr[0]);

  bucketSort(arr, n);

  for (int i = 0; i < n; i++) {
    printf("%d ", arr[i]);
  }

  return 0;
}