//Falcon-180B DATASET v1.0 Category: GPS Navigation Simulation ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_CITIES 100

// City structure
typedef struct {
    char name[20];
    double latitude;
    double longitude;
} City;

// Function to initialize GPS
void initGPS() {
    printf("Initializing GPS...\n");
    printf("Searching for satellites...\n");
    printf("Satellites found!\n");
    printf("GPS ready to use.\n");
}

// Function to get current location
void getCurrentLocation(double* latitude, double* longitude) {
    srand(time(NULL));
    *latitude = rand() % 90 - 45;
    *longitude = rand() % 180 - 90;
    printf("Current location: %.2f, %.2f\n", *latitude, *longitude);
}

// Function to add city
void addCity(City* cities, int numCities, char* name, double lat, double lon) {
    if (numCities >= MAX_CITIES) {
        printf("Cannot add more cities.\n");
        return;
    }
    strcpy(cities[numCities].name, name);
    cities[numCities].latitude = lat;
    cities[numCities].longitude = lon;
    numCities++;
}

// Function to navigate to city
void navigateToCity(City* cities, int numCities, double lat, double lon) {
    for (int i = 0; i < numCities; i++) {
        if (cities[i].latitude == lat && cities[i].longitude == lon) {
            printf("Navigating to %s...\n", cities[i].name);
            break;
        }
    }
}

int main() {
    City cities[MAX_CITIES];
    int numCities = 0;

    // Initialize GPS
    initGPS();

    // Add cities
    addCity(cities, numCities, "New York", 40.7128, -74.0060);
    addCity(cities, numCities, "Los Angeles", 34.0522, -118.2437);
    addCity(cities, numCities, "Chicago", 41.8781, -87.6298);

    // Navigate to city
    double lat, lon;
    getCurrentLocation(&lat, &lon);
    printf("Current location: %.2f, %.2f\n", lat, lon);
    navigateToCity(cities, numCities, lat, lon);

    return 0;
}