//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_EDGES 200
#define MAX_LINE 80

typedef struct Node {
    char name[MAX_LINE];
    int id;
} Node;

typedef struct Edge {
    Node from;
    Node to;
} Edge;

Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];

int num_nodes = 0;
int num_edges = 0;

void add_node(char *name) {
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].id = num_nodes;
    num_nodes++;
}

void add_edge(char *from, char *to) {
    int from_id = -1, to_id = -1;
    for (int i = 0; i < num_nodes; i++) {
        if (strcmp(nodes[i].name, from) == 0) {
            from_id = i;
        }
        if (strcmp(nodes[i].name, to) == 0) {
            to_id = i;
        }
    }
    if (from_id == -1 || to_id == -1) {
        printf("Error: Node not found.\n");
        return;
    }
    edges[num_edges].from = nodes[from_id];
    edges[num_edges].to = nodes[to_id];
    num_edges++;
}

void print_nodes() {
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d. %s\n", i, nodes[i].name);
    }
}

void print_edges() {
    printf("Edges:\n");
    for (int i = 0; i < num_edges; i++) {
        printf("%s -> %s\n", nodes[edges[i].from.id].name, nodes[edges[i].to.id].name);
    }
}

int main() {
    add_node("A");
    add_node("B");
    add_node("C");
    add_node("D");
    add_edge("A", "B");
    add_edge("B", "C");
    add_edge("C", "D");
    print_nodes();
    print_edges();
    return 0;
}