//GEMINI-pro DATASET v1.0 Category: Audio processing ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <portaudio.h>

#define NUM_CHANNELS  1
#define SAMPLE_RATE   44100
#define FRAMES_PER_BUFFER  512

static int audioCallback( const void *inputBuffer, void *outputBuffer,
                           unsigned long framesPerBuffer,
                           const PaStreamCallbackTimeInfo* timeInfo,
                           PaStreamCallbackFlags statusFlags,
                           void *userData )
{
    float *out = (float*)outputBuffer;
    int i;
    (void) inputBuffer; /* Prevent unused variable warning. */
    (void) timeInfo;
    (void) statusFlags;
    (void) userData;
    for( i=0; i<framesPerBuffer; i++ )
    {
        out[i] = (float)rand() / RAND_MAX;
    }
    return 0;
}

int main(void)
{
    PaStream *stream;
    PaError err;
    
    err = Pa_Initialize();
    if( err != paNoError ) goto error;

    err = Pa_OpenDefaultStream( &stream,
                                NUM_CHANNELS,
                                paNoDevice,
                                paFloat32,
                                SAMPLE_RATE,
                                FRAMES_PER_BUFFER,
                                audioCallback,
                                NULL );
    if( err != paNoError ) goto error;

    err = Pa_StartStream( stream );
    if( err != paNoError ) goto error;

    printf("Hit ENTER to stop the audio.\n");
    getchar();

    err = Pa_StopStream( stream );
    if( err != paNoError ) goto error;

    err = Pa_CloseStream( stream );
    if( err != paNoError ) goto error;

    Pa_Terminate();
    return 0;

error:
    Pa_Terminate();
    fprintf( stderr, "An error occurred while using the portaudio stream\n" );
    fprintf( stderr, "Error number: %d\n", err );
    fprintf( stderr, "Error message: %s\n", Pa_GetErrorText( err ) );
    return err;
}