//Falcon-180B DATASET v1.0 Category: Cryptographic hash function ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define HASH_SIZE 32

typedef struct {
    unsigned char hash[HASH_SIZE];
    int hash_size;
} hash_t;

hash_t hash_init(int size) {
    hash_t hash;
    hash.hash_size = size;
    for (int i = 0; i < HASH_SIZE; i++) {
        hash.hash[i] = 0;
    }
    return hash;
}

void hash_update(hash_t *hash, const char *data, int len) {
    int index = hash->hash_size % HASH_SIZE;
    for (int i = 0; i < len; i++) {
        hash->hash[index] ^= data[i];
        index = (index + 1) % HASH_SIZE;
    }
}

void hash_final(hash_t *hash, char *digest) {
    int index = hash->hash_size % HASH_SIZE;
    for (int i = 0; i < HASH_SIZE; i++) {
        sprintf(&digest[i*2], "%02x", hash->hash[index]);
        index = (index + 1) % HASH_SIZE;
    }
}

int main() {
    char data[] = "The quick brown fox jumps over the lazy dog.";
    int data_len = strlen(data);

    hash_t hash = hash_init(data_len);
    hash_update(&hash, data, data_len);
    char digest[HASH_SIZE*2+1];
    hash_final(&hash, digest);

    printf("Data: %s\n", data);
    printf("Hash: %s\n", digest);

    return 0;
}