//GPT-4o-mini DATASET v1.0 Category: Modern Encryption ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/aes.h>
#include <openssl/rand.h>

#define AES_BLOCK_SIZE 16 // AES block size in bytes
#define KEY_SIZE 128      // Key size in bits

void handleErrors(void) {
    ERR_print_errors_fp(stderr);
    abort();
}

void encrypt(const unsigned char *key, const unsigned char *plaintext, unsigned char *ciphertext) {
    AES_KEY encryptKey;
    if (AES_set_encrypt_key(key, KEY_SIZE, &encryptKey) < 0) {
        handleErrors();
    }

    // Pad plaintext to be multiple of AES_BLOCK_SIZE
    unsigned char padded[32];
    int pad_len = AES_BLOCK_SIZE - (strlen((const char *)plaintext) % AES_BLOCK_SIZE);
    snprintf((char *)padded, sizeof(padded), "%s%.*s", plaintext, pad_len, "");
    
    AES_encrypt(padded, ciphertext, &encryptKey);
}

void decrypt(const unsigned char *key, const unsigned char *ciphertext, unsigned char *decryptedtext) {
    AES_KEY decryptKey;
    if (AES_set_decrypt_key(key, KEY_SIZE, &decryptKey) < 0) {
        handleErrors();
    }

    AES_decrypt(ciphertext, decryptedtext, &decryptKey);
}

void generateKey(unsigned char *key) {
    if (!RAND_bytes(key, KEY_SIZE / 8)) {
        handleErrors();
    }
}

int main() {
    unsigned char key[AES_BLOCK_SIZE]; // 128 bit key
    generateKey(key);

    // Example plaintext
    unsigned char *plaintext = (unsigned char *)"Hello, World!";
    unsigned char ciphertext[AES_BLOCK_SIZE];
    unsigned char decryptedtext[AES_BLOCK_SIZE];
    
    printf("Original Plaintext: %s\n", plaintext);
    
    encrypt(key, plaintext, ciphertext);
    printf("Ciphertext: ");
    for(int i = 0; i < AES_BLOCK_SIZE; i++) {
        printf("%02x", ciphertext[i]);
    }
    printf("\n");

    decrypt(key, ciphertext, decryptedtext);
    decryptedtext[AES_BLOCK_SIZE - 1] = '\0'; // Null-terminate string for display
    printf("Decrypted Text: %s\n", decryptedtext);

    return 0;
}