//GEMINI-pro DATASET v1.0 Category: Digital Auction System ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

// Define the maximum number of bids and items
#define MAX_BIDS 100
#define MAX_ITEMS 10

// Define the struct for an item
typedef struct {
    int id;
    char *name;
    char *description;
    int starting_price;
    int current_price;
    int highest_bidder;
    int num_bids;
} Item;

// Define the struct for a bid
typedef struct {
    int id;
    int item_id;
    int bidder_id;
    int amount;
} Bid;

// Define the global variables
int num_items = 0;
Item items[MAX_ITEMS];
int num_bids = 0;
Bid bids[MAX_BIDS];

// Function to initialize the auction system
void init_auction() {
    // Create some items
    Item item1 = {1, "Item 1", "This is the first item.", 100, 100, 0, 0};
    Item item2 = {2, "Item 2", "This is the second item.", 200, 200, 0, 0};
    Item item3 = {3, "Item 3", "This is the third item.", 300, 300, 0, 0};
    items[num_items++] = item1;
    items[num_items++] = item2;
    items[num_items++] = item3;
}

// Function to place a bid
void place_bid(int item_id, int bidder_id, int amount) {
    // Check if the item exists
    int i;
    for (i = 0; i < num_items; i++) {
        if (items[i].id == item_id) {
            break;
        }
    }
    if (i == num_items) {
        printf("Error: Item not found.\n");
        return;
    }

    // Check if the bid is valid
    if (amount <= items[i].current_price) {
        printf("Error: Bid amount must be greater than the current price.\n");
        return;
    }

    // Create a new bid
    Bid bid = {num_bids++, item_id, bidder_id, amount};
    bids[num_bids++] = bid;

    // Update the item's current price and highest bidder
    items[i].current_price = amount;
    items[i].highest_bidder = bidder_id;
}

// Function to end an auction
void end_auction(int item_id) {
    // Check if the item exists
    int i;
    for (i = 0; i < num_items; i++) {
        if (items[i].id == item_id) {
            break;
        }
    }
    if (i == num_items) {
        printf("Error: Item not found.\n");
        return;
    }

    // End the auction for the item
    items[i].num_bids = 0;
    items[i].highest_bidder = 0;
    items[i].current_price = items[i].starting_price;
}

// Function to print the current status of the auction
void print_auction() {
    int i;
    for (i = 0; i < num_items; i++) {
        printf("Item %d: %s\n", items[i].id, items[i].name);
        printf("  Starting price: %d\n", items[i].starting_price);
        printf("  Current price: %d\n", items[i].current_price);
        printf("  Highest bidder: %d\n", items[i].highest_bidder);
        printf("  Number of bids: %d\n", items[i].num_bids);
        printf("\n");
    }
}

// Main function
int main() {
    // Initialize the auction system
    init_auction();

    // Place some bids
    place_bid(1, 1, 110);
    place_bid(1, 2, 120);
    place_bid(2, 1, 210);
    place_bid(2, 2, 220);
    place_bid(3, 1, 310);
    place_bid(3, 2, 320);

    // End the auction for item 1
    end_auction(1);

    // Print the current status of the auction
    print_auction();

    return 0;
}