//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>

// Define a structure to store customer information
typedef struct customer {
  char name[20];
  char address[50];
  int phone;
} customer;

// Define a structure to store item information
typedef struct item {
  char name[20];
  int price;
  int quantity;
} item;

// Function to calculate the total cost of an item
int calculate_total_cost(item item) {
  return item.price * item.quantity;
}

// Function to calculate the total cost of a customer's order
int calculate_total_order_cost(customer customer, item item) {
  return calculate_total_cost(item) + customer.phone;
}

// Function to print the bill
void print_bill(customer customer, item item) {
  printf("-------------------------------------------------------\n");
  printf("Customer Name: %s\n", customer.name);
  printf("Customer Address: %s\n", customer.address);
  printf("Customer Phone: %d\n", customer.phone);
  printf("Item Name: %s\n", item.name);
  printf("Item Price: %d\n", item.price);
  printf("Item Quantity: %d\n", item.quantity);
  printf("Total Cost: %d\n", calculate_total_order_cost(customer, item));
  printf("-------------------------------------------------------\n");
}

int main() {
  // Create a customer structure
  customer customer;
  strcpy(customer.name, "John Doe");
  strcpy(customer.address, "123 Main St.");
  customer.phone = 5551234;

  // Create an item structure
  item item;
  strcpy(item.name, "Coffee");
  item.price = 2.50;
  item.quantity = 2;

  // Calculate the total cost of the order
  int total_cost = calculate_total_order_cost(customer, item);

  // Print the bill
  print_bill(customer, item);

  // Print the total cost
  printf("Total Cost: %d\n", total_cost);

  return 0;
}