//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int main() {
    int a = 0b10101010;
    int b = 0b01010101;
    int x = 0;
    int y = 0;
    int result;

    // Bitwise AND operation
    result = a & b;
    printf("Bitwise AND operation result: %d\n", result);

    // Bitwise OR operation
    result = a | b;
    printf("Bitwise OR operation result: %d\n", result);

    // Bitwise XOR operation
    result = a ^ b;
    printf("Bitwise XOR operation result: %d\n", result);

    // Bitwise NOT operation
    result = ~a;
    printf("Bitwise NOT operation result: %d\n", result);

    // Bitwise left shift operation
    result = a << 2;
    printf("Bitwise left shift operation result: %d\n", result);

    // Bitwise right shift operation
    result = a >> 2;
    printf("Bitwise right shift operation result: %d\n", result);

    // Bit manipulation
    x = 0b10101010;
    y = 0b01010101;
    int c = x & ~y;
    int d = x | y;
    int e = x ^ y;
    int f = x & (x - 1);
    int g = x | (x - 1);
    printf("Bit manipulation results:\n");
    printf("c = %d\n", c);
    printf("d = %d\n", d);
    printf("e = %d\n", e);
    printf("f = %d\n", f);
    printf("g = %d\n", g);

    // Bitwise operations with bit masks
    int mask1 = 0b11111111;
    int mask2 = 0b00000001;
    int mask3 = 0b11111100;
    int mask4 = 0b00000010;
    int value = 0b10101010;
    int result1 = value & mask1;
    int result2 = value | mask2;
    int result3 = value ^ mask3;
    int result4 = value & ~mask4;
    printf("Bitwise operations with bit masks results:\n");
    printf("result1 = %d\n", result1);
    printf("result2 = %d\n", result2);
    printf("result3 = %d\n", result3);
    printf("result4 = %d\n", result4);

    return 0;
}