//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

int main() {
    // Create a socket
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket");
        exit(1);
    }

    // Bind the socket to an address
    struct sockaddr_in addr;
    addr.sin_family = AF_INET;
    addr.sin_port = htons(12345);
    addr.sin_addr.s_addr = htonl(INADDR_ANY);
    if (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
        perror("bind");
        exit(1);
    }

    // Listen for connections
    if (listen(sock, 5) < 0) {
        perror("listen");
        exit(1);
    }

    // Accept a connection
    int client_sock = accept(sock, NULL, NULL);
    if (client_sock < 0) {
        perror("accept");
        exit(1);
    }

    // Send a message to the client
    const char *message = "Hello, world!\n";
    if (send(client_sock, message, strlen(message), 0) < 0) {
        perror("send");
        exit(1);
    }

    // Close the client socket
    close(client_sock);

    // Close the server socket
    close(sock);

    return 0;
}