//Falcon-180B DATASET v1.0 Category: Traffic Light Controller ; Style: creative
#include<stdio.h>
#include<stdlib.h>
#include<time.h>

// Defining the number of roads
#define NUM_ROADS 4

// Defining the time for each signal in seconds
#define RED_LIGHT_TIME 30
#define YELLOW_LIGHT_TIME 5
#define GREEN_LIGHT_TIME 25

void road1() {
    printf("Road 1\n");
}

void road2() {
    printf("Road 2\n");
}

void road3() {
    printf("Road 3\n");
}

void road4() {
    printf("Road 4\n");
}

void signal(int road) {
    switch(road) {
        case 1:
            printf("Signal for Road 1\n");
            break;
        case 2:
            printf("Signal for Road 2\n");
            break;
        case 3:
            printf("Signal for Road 3\n");
            break;
        case 4:
            printf("Signal for Road 4\n");
            break;
        default:
            printf("Invalid Road\n");
            break;
    }
}

void changeSignal(int road, int currentSignal, int nextSignal) {
    signal(road);
    if(currentSignal == 1) {
        printf("Current Signal: Red\n");
        printf("Next Signal: Green\n");
    }
    else if(currentSignal == 2) {
        printf("Current Signal: Yellow\n");
        printf("Next Signal: Red\n");
    }
    else if(currentSignal == 3) {
        printf("Current Signal: Green\n");
        printf("Next Signal: Yellow\n");
    }
    else {
        printf("Invalid Signal\n");
    }
    printf("Changing Signal...\n");
    sleep(1);
    printf("Signal Changed\n\n");
}

int main() {
    int i, j;
    for(i=0; i<NUM_ROADS; i++) {
        for(j=0; j<3; j++) {
            changeSignal(i+1, 1, 2);
            sleep(RED_LIGHT_TIME);
            changeSignal(i+1, 2, 3);
            sleep(YELLOW_LIGHT_TIME);
            changeSignal(i+1, 3, 1);
            sleep(GREEN_LIGHT_TIME);
        }
    }
    return 0;
}