//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: secure
#include <stdlib.h>
#include <stdio.h>

// Process structure
typedef struct Process {
    int pid;            // Process ID
    int arrival_time;   // Arrival time
    int burst_time;     // Burst time
    int priority;       // Priority
    int remaining_time; // Remaining time
    int waiting_time;   // Waiting time
    int turnaround_time;// Turnaround time
} Process;

// Function to compare processes by arrival time
int compare_arrival_time(const void *a, const void *b) {
    const Process *p1 = (const Process *)a;
    const Process *p2 = (const Process *)b;
    return p1->arrival_time - p2->arrival_time;
}

// Function to compare processes by priority
int compare_priority(const void *a, const void *b) {
    const Process *p1 = (const Process *)a;
    const Process *p2 = (const Process *)b;
    return p1->priority - p2->priority;
}

// Function to calculate waiting time and turnaround time
void calculate_waiting_and_turnaround_time(Process *processes, int num_processes) {
    int current_time = 0;

    for (int i = 0; i < num_processes; i++) {
        // Calculate waiting time
        processes[i].waiting_time = current_time - processes[i].arrival_time;

        // Calculate turnaround time
        processes[i].turnaround_time = processes[i].waiting_time + processes[i].burst_time;

        // Update current time
        current_time += processes[i].burst_time;
    }
}

// Function to print the results
void print_results(Process *processes, int num_processes) {
    printf("Process\tArrival Time\tBurst Time\tPriority\tWaiting Time\tTurnaround Time\n");

    for (int i = 0; i < num_processes; i++) {
        printf("%d\t\t%d\t\t%d\t\t%d\t\t%d\t\t%d\n", processes[i].pid, processes[i].arrival_time, processes[i].burst_time, processes[i].priority, processes[i].waiting_time, processes[i].turnaround_time);
    }
}

// Main function
int main() {
    // Create an array of processes
    Process processes[] = {
        {1, 0, 5, 3},
        {2, 2, 3, 1},
        {3, 4, 4, 2},
        {4, 6, 2, 4}
    };

    // Sort the processes by arrival time
    qsort(processes, sizeof(processes) / sizeof(Process), sizeof(Process), compare_arrival_time);

    // Schedule the processes using priority scheduling
    calculate_waiting_and_turnaround_time(processes, sizeof(processes) / sizeof(Process));

    // Print the results
    print_results(processes, sizeof(processes) / sizeof(Process));

    return 0;
}