//GEMINI-pro DATASET v1.0 Category: Searching algorithm ; Style: Romeo and Juliet
#include <stdio.h>

// Fair Verona, where we lay our scene,
// A prologue, ladies and gentlemen.
void prologue() {
    printf("Two households, both alike in dignity,\n"
           "In fair Verona, where we lay our scene,\n"
           "From ancient grudge break to new mutiny,\n"
           "Where civil blood makes civil hands unclean.\n"
           "\n"
           "From forth the fatal loins of these two foes\n"
           "A pair of star-cross'd lovers take their life;\n"
           "Whose misadventur'd piteous overthrows\n"
           "Do with their death bury their parents' strife.\n"
           "\n"
           "The fearful passage of their death-mark'd love,\n"
           "And the continuance of their parents' rage,\n"
           "Which, but their children's end, naught could remove,\n"
           "Is now the two hours' traffic of our stage;\n"
           "\n"
           "The which if you with patient ears attend,\n"
           "What here shall miss, our toil shall strive to mend.\n");
}

// The Montagues and Capulets
int montagues[] = {1, 3, 5, 7, 9};
int capulets[] = {2, 4, 6, 8, 10};

// Romeo and Juliet
int romeo = 5;
int juliet = 8;

// Friar Laurence's cell
int cell[] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

// Searching for Romeo
int find_romeo(int *arr, int n, int target) {
    for (int i = 0; i < n; i++) {
        if (arr[i] == target) {
            return i;
        }
    }
    return -1;
}

// Searching for Juliet
int find_juliet(int *arr, int n, int target) {
    for (int i = 0; i < n; i++) {
        if (arr[i] == target) {
            return i;
        }
    }
    return -1;
}

// Main
int main() {
    prologue();

    // Romeo is in the Montague household
    int romeo_index = find_romeo(montagues, 5, romeo);
    printf("Romeo is in the Montague household at index %d.\n", romeo_index);

    // Juliet is in the Capulet household
    int juliet_index = find_juliet(capulets, 5, juliet);
    printf("Juliet is in the Capulet household at index %d.\n", juliet_index);

    // Romeo and Juliet meet in Friar Laurence's cell
    int cell_index = find_romeo(cell, 10, romeo);
    if (cell_index >= 0) {
        printf("Romeo is in Friar Laurence's cell at index %d.\n", cell_index);
    }
    cell_index = find_juliet(cell, 10, juliet);
    if (cell_index >= 0) {
        printf("Juliet is in Friar Laurence's cell at index %d.\n", cell_index);
    }

    return 0;
}