//GEMINI-pro DATASET v1.0 Category: System administration ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

int main() {
    // Define the file and directory paths.
    const char *file_path = "example.txt";
    const char *dir_path = "example_dir";

    // Create the example directory.
    if (mkdir(dir_path, S_IRWXU | S_IRWXG | S_IROTH) == -1) {
        perror("mkdir");
        exit(EXIT_FAILURE);
    }

    // Create the example file.
    int fd = open(file_path, O_WRONLY | O_CREAT | O_TRUNC, S_IRUSR | S_IWUSR);
    if (fd == -1) {
        perror("open");
        exit(EXIT_FAILURE);
    }

    // Write some data to the file.
    const char *data = "Hello, world!";
    if (write(fd, data, strlen(data)) == -1) {
        perror("write");
        exit(EXIT_FAILURE);
    }

    // Close the file.
    if (close(fd) == -1) {
        perror("close");
        exit(EXIT_FAILURE);
    }

    // Change the permissions of the file.
    if (chmod(file_path, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH) == -1) {
        perror("chmod");
        exit(EXIT_FAILURE);
    }

    // Change the ownership of the file.
    if (chown(file_path, getuid(), getgid()) == -1) {
        perror("chown");
        exit(EXIT_FAILURE);
    }

    // Print a success message.
    printf("System administration tasks completed successfully.\n");

    // Delete the file and directory.
    if (unlink(file_path) == -1) {
        perror("unlink");
        exit(EXIT_FAILURE);
    }

    if (rmdir(dir_path) == -1) {
        perror("rmdir");
        exit(EXIT_FAILURE);
    }

    return EXIT_SUCCESS;
}