//GEMINI-pro DATASET v1.0 Category: Fitness Tracker ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <time.h>

// Define the maximum number of steps that can be recorded
#define MAX_STEPS 10000

// Define the maximum number of calories that can be burned
#define MAX_CALORIES 1000

// Define the maximum number of minutes that can be exercised
#define MAX_MINUTES 60

// Create a struct to store the fitness data
typedef struct {
    int steps;
    int calories;
    int minutes;
} FitnessData;

// Create a function to initialize the fitness data
void initializeFitnessData(FitnessData *data) {
    data->steps = 0;
    data->calories = 0;
    data->minutes = 0;
}

// Create a function to add steps to the fitness data
void addSteps(FitnessData *data, int steps) {
    if (data->steps + steps <= MAX_STEPS) {
        data->steps += steps;
    }
}

// Create a function to add calories to the fitness data
void addCalories(FitnessData *data, int calories) {
    if (data->calories + calories <= MAX_CALORIES) {
        data->calories += calories;
    }
}

// Create a function to add minutes to the fitness data
void addMinutes(FitnessData *data, int minutes) {
    if (data->minutes + minutes <= MAX_MINUTES) {
        data->minutes += minutes;
    }
}

// Create a function to print the fitness data
void printFitnessData(FitnessData *data) {
    printf("Steps: %d\n", data->steps);
    printf("Calories: %d\n", data->calories);
    printf("Minutes: %d\n", data->minutes);
}

// Create a function to generate a random fitness data
FitnessData generateRandomFitnessData() {
    FitnessData data;
    initializeFitnessData(&data);
    int steps = rand() % MAX_STEPS;
    int calories = rand() % MAX_CALORIES;
    int minutes = rand() % MAX_MINUTES;
    addSteps(&data, steps);
    addCalories(&data, calories);
    addMinutes(&data, minutes);
    return data;
}

// Create a function to test the fitness tracker
void testFitnessTracker() {
    FitnessData data;
    initializeFitnessData(&data);
    addSteps(&data, 1000);
    addCalories(&data, 200);
    addMinutes(&data, 30);
    printFitnessData(&data);
    FitnessData randomData = generateRandomFitnessData();
    printFitnessData(&randomData);
}

int main() {
    srand(time(NULL));
    testFitnessTracker();
    return 0;
}