//Falcon-180B DATASET v1.0 Category: Expense Tracker ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>

// Define the structure for expenses
typedef struct {
    char name[50];
    int amount;
} Expense;

// Function to add an expense
void add_expense(Expense *expenses, int size, int count, char name[], int amount) {
    if (count >= size) {
        printf("Error: Cannot add more expenses.\n");
        return;
    }
    strcpy(expenses[count].name, name);
    expenses[count].amount = amount;
    count++;
}

// Function to display all expenses
void display_expenses(Expense expenses[], int size, int count) {
    printf("Expenses:\n");
    for (int i = 0; i < count; i++) {
        printf("%s: $%d\n", expenses[i].name, expenses[i].amount);
    }
}

// Function to calculate total expenses
int calculate_total_expenses(Expense expenses[], int size, int count) {
    int total_expenses = 0;
    for (int i = 0; i < count; i++) {
        total_expenses += expenses[i].amount;
    }
    return total_expenses;
}

// Function to calculate average expenses
float calculate_average_expenses(Expense expenses[], int size, int count) {
    int total_expenses = calculate_total_expenses(expenses, size, count);
    return (float) total_expenses / count;
}

int main() {
    Expense expenses[100]; // define an array to store expenses
    int size = sizeof(expenses) / sizeof(Expense); // calculate the size of the array
    int count = 0; // initialize the count of expenses to 0

    add_expense(expenses, size, count, "Groceries", 100);
    add_expense(expenses, size, count, "Rent", 500);
    add_expense(expenses, size, count, "Utilities", 200);
    add_expense(expenses, size, count, "Entertainment", 50);

    display_expenses(expenses, size, count);

    int total_expenses = calculate_total_expenses(expenses, size, count);
    printf("Total expenses: $%d\n", total_expenses);

    float average_expenses = calculate_average_expenses(expenses, size, count);
    printf("Average expenses: $%.2f\n", average_expenses);

    return 0;
}