//Falcon-180B DATASET v1.0 Category: Digital Auction System ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_USERS 50
#define MAX_BIDS 1000

typedef struct {
    char name[50];
    int user_id;
} User;

typedef struct {
    char name[100];
    double price;
    int item_id;
} Item;

typedef struct {
    int user_id;
    int item_id;
    double bid_amount;
} Bid;

int num_users = 0;
User users[MAX_USERS];

int num_items = 0;
Item items[MAX_ITEMS];

int num_bids = 0;
Bid bids[MAX_BIDS];

void add_user(char* name) {
    strcpy(users[num_users].name, name);
    users[num_users].user_id = num_users + 1;
    num_users++;
}

int get_user_id(char* name) {
    for (int i = 0; i < num_users; i++) {
        if (strcmp(users[i].name, name) == 0) {
            return users[i].user_id;
        }
    }
    return -1;
}

void add_item(char* name, double price, int id) {
    strcpy(items[num_items].name, name);
    items[num_items].price = price;
    items[num_items].item_id = id;
    num_items++;
}

int get_item_id(char* name) {
    for (int i = 0; i < num_items; i++) {
        if (strcmp(items[i].name, name) == 0) {
            return items[i].item_id;
        }
    }
    return -1;
}

void place_bid(int user_id, int item_id, double amount) {
    Bid bid;
    bid.user_id = user_id;
    bid.item_id = item_id;
    bid.bid_amount = amount;
    bids[num_bids] = bid;
    num_bids++;
}

double get_highest_bid(int item_id) {
    double highest_bid = 0;
    for (int i = 0; i < num_bids; i++) {
        if (bids[i].item_id == item_id && bids[i].bid_amount > highest_bid) {
            highest_bid = bids[i].bid_amount;
        }
    }
    return highest_bid;
}

int main() {
    // Add users
    add_user("Alice");
    add_user("Bob");
    add_user("Charlie");

    // Add items
    add_item("iPhone", 1000, 1);
    add_item("MacBook", 2000, 2);
    add_item("PlayStation", 300, 3);

    // Place bids
    place_bid(1, 1, 900);
    place_bid(2, 1, 950);
    place_bid(3, 2, 1800);

    // Print highest bids
    printf("Highest bid for iPhone: $%.2f\n", get_highest_bid(1));
    printf("Highest bid for MacBook: $%.2f\n", get_highest_bid(2));
    printf("Highest bid for PlayStation: $%.2f\n", get_highest_bid(3));

    return 0;
}