//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESS 5

typedef struct Process {
    int process_id;
    int arrival_time;
    int execution_time;
    int waiting_time;
    int turnaround_time;
} Process;

void calculate_cpu_scheduling(Process processes[]) {
    int i, j;
    for (i = 0; i < MAX_PROCESS; i++) {
        processes[i].waiting_time = 0;
        for (j = 0; j < MAX_PROCESS; j++) {
            if (processes[j].arrival_time < processes[i].arrival_time) {
                processes[i].waiting_time++;
            }
        }

        processes[i].turnaround_time = processes[i].waiting_time + processes[i].execution_time;
    }
}

int main() {
    Process processes[MAX_PROCESS];

    // Initialize processes
    processes[0].process_id = 1;
    processes[0].arrival_time = 0;
    processes[0].execution_time = 5;

    processes[1].process_id = 2;
    processes[1].arrival_time = 2;
    processes[1].execution_time = 4;

    processes[2].process_id = 3;
    processes[2].arrival_time = 3;
    processes[2].execution_time = 3;

    processes[3].process_id = 4;
    processes[3].arrival_time = 4;
    processes[3].execution_time = 2;

    processes[4].process_id = 5;
    processes[4].arrival_time = 5;
    processes[4].execution_time = 1;

    // Calculate CPU scheduling
    calculate_cpu_scheduling(processes);

    // Print results
    for (int i = 0; i < MAX_PROCESS; i++) {
        printf("Process ID: %d, Waiting Time: %d, Turnaround Time: %d\n", processes[i].process_id, processes[i].waiting_time, processes[i].turnaround_time);
    }

    return 0;
}