//Code Llama-13B DATASET v1.0 Category: Client Server Application ; Style: relaxed
// Client Server Application Example Program

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>

// Function to create a socket
int createSocket(int port) {
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock == -1) {
        perror("socket");
        exit(1);
    }
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(port);
    server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");
    if (connect(sock, (struct sockaddr*)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect");
        exit(1);
    }
    return sock;
}

// Function to send a message to the server
void sendMessage(int sock, char* message) {
    send(sock, message, strlen(message), 0);
}

// Function to receive a message from the server
char* receiveMessage(int sock) {
    char buffer[1024];
    int n = recv(sock, buffer, sizeof(buffer), 0);
    if (n < 0) {
        perror("recv");
        exit(1);
    }
    return buffer;
}

int main(int argc, char** argv) {
    // Create a socket and connect to the server
    int sock = createSocket(8000);

    // Send a message to the server
    sendMessage(sock, "Hello, Server!");

    // Receive a message from the server
    char* message = receiveMessage(sock);
    printf("Received message from server: %s\n", message);

    // Close the socket
    close(sock);
    return 0;
}