//Gemma-7B DATASET v1.0 Category: Elevator Simulation ; Style: intelligent
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#define MAX_FLOORS 20

typedef struct Elevator {
    int currentFloor;
    int targetFloor;
    int passengers;
    int direction;
} Elevator;

Elevator createElevator() {
    Elevator elevator;
    elevator.currentFloor = 1;
    elevator.targetFloor = 1;
    elevator.passengers = 0;
    elevator.direction = 0;
    return elevator;
}

void moveElevator(Elevator *elevator) {
    int targetFloor = elevator->targetFloor;
    int currentFloor = elevator->currentFloor;

    if (currentFloor == targetFloor) {
        return;
    }

    int direction = elevator->direction;

    if (direction == 0) { // Upward
        elevator->currentFloor++;
    } else if (direction == 1) { // Downward
        elevator->currentFloor--;
    }

    if (elevator->currentFloor > targetFloor) {
        elevator->direction = 1;
    } else if (elevator->currentFloor < targetFloor) {
        elevator->direction = 0;
    }

    if (elevator->passengers > 0) {
        printf("Elevator is moving to floor %d with %d passengers.\n", elevator->currentFloor, elevator->passengers);
    } else {
        printf("Elevator is moving to floor %d.\n", elevator->currentFloor);
    }
}

int main() {
    Elevator elevator = createElevator();

    // Simulate elevator movement
    for (int i = 0; i < 10; i++) {
        moveElevator(&elevator);
    }

    return 0;
}