//Falcon-180B DATASET v1.0 Category: Classical Circuit Simulator ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX_COMPONENTS 100
#define MAX_NODES 1000
#define PI 3.14159265358979323846

typedef struct {
    double value;
    int node1;
    int node2;
} component_t;

typedef struct {
    double value;
    int node;
} node_t;

component_t components[MAX_COMPONENTS];
node_t nodes[MAX_NODES];
int num_components;
int num_nodes;

void add_component(double value, int node1, int node2) {
    if (num_components >= MAX_COMPONENTS) {
        printf("Error: Maximum number of components reached.\n");
        exit(1);
    }
    components[num_components].value = value;
    components[num_components].node1 = node1;
    components[num_components].node2 = node2;
    num_components++;
}

void add_node(double value) {
    if (num_nodes >= MAX_NODES) {
        printf("Error: Maximum number of nodes reached.\n");
        exit(1);
    }
    nodes[num_nodes].value = value;
    nodes[num_nodes].node = num_nodes;
    num_nodes++;
}

void solve() {
    int i, j;
    for (i = 0; i < num_nodes; i++) {
        nodes[i].value = 0;
    }
    for (i = 0; i < num_components; i++) {
        int node1 = components[i].node1;
        int node2 = components[i].node2;
        nodes[node1].value -= components[i].value;
        nodes[node2].value += components[i].value;
    }
    for (i = 0; i < num_nodes; i++) {
        for (j = 0; j < num_nodes; j++) {
            if (i!= j) {
                double resistance = 1 / components[0].value;
                nodes[i].value += resistance * (nodes[j].value - nodes[i].value);
            }
        }
    }
}

void print_results() {
    printf("Node\tVoltage\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d\t%.4f\n", i, nodes[i].value);
    }
}

int main() {
    add_node(5);
    add_node(0);
    add_node(10);
    add_component(1, 0, 1);
    add_component(1, 1, 2);
    solve();
    print_results();
    return 0;
}