//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOULS 10

typedef struct Ghost {
  char name[20];
  int room;
  int health;
  int action;
} Ghost;

Ghost ghosts[MAX_GHOULS];

void initializeGhosts() {
  for (int i = 0; i < MAX_GHOULS; i++) {
    ghosts[i].name[0] = '\0';
    ghosts[i].room = -1;
    ghosts[i].health = 100;
    ghosts[i].action = -1;
  }
}

void spawnGhosts() {
  for (int i = 0; i < MAX_GHOULS; i++) {
    ghosts[i].name[0] = 'A' + i;
    ghosts[i].room = rand() % 5;
  }
}

void moveGhosts() {
  for (int i = 0; i < MAX_GHOULS; i++) {
    switch (ghosts[i].action) {
      case 0:
        ghosts[i].room = rand() % 5;
        break;
      case 1:
        ghosts[i].health--;
        break;
    }
  }
}

void interactWithGhosts() {
  for (int i = 0; i < MAX_GHOULS; i++) {
    if (ghosts[i].health <= 0) {
      ghosts[i].action = -1;
    }
  }
}

int main() {
  initializeGhosts();
  spawnGhosts();
  moveGhosts();
  interactWithGhosts();

  return 0;
}