//Falcon-180B DATASET v1.0 Category: Smart home automation ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_COMMANDS 100
#define MAX_COMMAND_LENGTH 100
#define MAX_SENSOR_TYPES 100

// Structure to hold sensor data
typedef struct {
    char name[50];
    int value;
} SensorData;

// Structure to hold command data
typedef struct {
    char name[50];
    int value;
    time_t timestamp;
} CommandData;

// Global variables
int numSensors = 0;
int numCommands = 0;
SensorData sensors[MAX_SENSOR_TYPES];
CommandData commands[MAX_COMMANDS];

// Function to add a new sensor
void addSensor(char* name, int value) {
    strcpy(sensors[numSensors].name, name);
    sensors[numSensors].value = value;
    numSensors++;
}

// Function to add a new command
void addCommand(char* name, int value, time_t timestamp) {
    strcpy(commands[numCommands].name, name);
    commands[numCommands].value = value;
    commands[numCommands].timestamp = timestamp;
    numCommands++;
}

// Function to print sensor data
void printSensorData() {
    printf("Sensor Data:\n");
    for(int i=0; i<numSensors; i++) {
        printf("Name: %s, Value: %d\n", sensors[i].name, sensors[i].value);
    }
}

// Function to print command data
void printCommandData() {
    printf("Command Data:\n");
    for(int i=0; i<numCommands; i++) {
        printf("Name: %s, Value: %d, Timestamp: %s\n", commands[i].name, commands[i].value, ctime(&commands[i].timestamp));
    }
}

// Function to execute a command
void executeCommand(char* name) {
    for(int i=0; i<numCommands; i++) {
        if(strcmp(name, commands[i].name) == 0) {
            // Execute command logic here
            printf("Command executed: %s\n", name);
            break;
        }
    }
}

// Main function
int main() {
    // Initialize random seed
    srand(time(NULL));

    // Add sample sensors
    addSensor("Temperature", rand() % 100);
    addSensor("Humidity", rand() % 100);

    // Add sample commands
    addCommand("Turn on lights", 1, time(NULL));
    addCommand("Turn off lights", 0, time(NULL));

    // Print initial sensor data
    printSensorData();

    // Execute a command
    executeCommand("Turn on lights");

    // Print updated sensor data
    printSensorData();

    // Print command data
    printCommandData();

    return 0;
}