//Falcon2-11B DATASET v1.0 Category: Socket programming ; Style: all-encompassing
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

int main()
{
    // Create a socket
    int sockfd;
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    // Create an address structure for the remote server
    struct sockaddr_in server_addr;
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(12345);
    server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connect to the remote server
    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0)
    {
        perror("connect failed");
        exit(EXIT_FAILURE);
    }

    // Send a message to the remote server
    char msg[] = "Hello, world!";
    if (send(sockfd, msg, strlen(msg), 0) < 0)
    {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    // Receive a response from the remote server
    char response[100];
    if (recv(sockfd, response, sizeof(response), 0) < 0)
    {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }

    // Print the response
    printf("Response: %s\n", response);

    // Close the socket
    close(sockfd);

    return 0;
}