//Falcon-180B DATASET v1.0 Category: Database Indexing System ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_ENTRIES 1000
#define MAX_NAME 50
#define MAX_VALUE 200

typedef struct {
    char name[MAX_NAME];
    int index;
    char value[MAX_VALUE];
} Entry;

Entry entries[MAX_ENTRIES];
int num_entries = 0;

int compare_entries(const void* a, const void* b) {
    Entry* entry1 = (Entry*)a;
    Entry* entry2 = (Entry*)b;

    return strcmp(entry1->name, entry2->name);
}

void add_entry(char* name, char* value) {
    if (num_entries >= MAX_ENTRIES) {
        printf("Error: maximum number of entries reached.\n");
        return;
    }

    Entry* new_entry = &entries[num_entries];
    strcpy(new_entry->name, name);
    strcpy(new_entry->value, value);
    new_entry->index = num_entries;

    num_entries++;
}

void search_entries(char* query) {
    qsort(entries, num_entries, sizeof(Entry), compare_entries);

    for (int i = 0; i < num_entries; i++) {
        Entry* entry = &entries[i];

        if (strstr(entry->name, query)!= NULL || strstr(entry->value, query)!= NULL) {
            printf("Name: %s\nValue: %s\n", entry->name, entry->value);
        }
    }
}

int main() {
    add_entry("John", "555-1234");
    add_entry("Jane", "555-5678");
    add_entry("Bob", "555-9876");

    search_entries("555");

    return 0;
}