//Falcon-180B DATASET v1.0 Category: Terminal Based Game ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROWS 3
#define COLS 3
#define MIN_VALUE 1
#define MAX_VALUE 9

void draw_board(int board[ROWS][COLS]) {
    int i, j;

    for (i = 0; i < ROWS; i++) {
        for (j = 0; j < COLS; j++) {
            printf("%d ", board[i][j]);
        }
        printf("\n");
    }
}

int check_win(int board[ROWS][COLS]) {
    int i;

    // Check rows
    for (i = 0; i < ROWS; i++) {
        if (board[i][0] == board[i][1] && board[i][1] == board[i][2]) {
            return 1;
        }
    }

    // Check columns
    for (i = 0; i < COLS; i++) {
        if (board[0][i] == board[1][i] && board[1][i] == board[2][i]) {
            return 1;
        }
    }

    // Check diagonals
    if (board[0][0] == board[1][1] && board[1][1] == board[2][2]) {
        return 1;
    }

    if (board[0][2] == board[1][1] && board[1][1] == board[2][0]) {
        return 1;
    }

    return 0;
}

void play_game(int board[ROWS][COLS]) {
    int player = 1;
    int choice;
    int valid_move = 0;

    while (!check_win(board)) {
        draw_board(board);

        printf("\nPlayer %d's turn. Enter your move (row and column): ", player);
        scanf("%d%d", &choice, &choice);

        if (choice >= MIN_VALUE && choice <= MAX_VALUE) {
            if (board[choice - 1][choice - 1] == 0) {
                board[choice - 1][choice - 1] = player;
                valid_move = 1;
            }
        }

        if (!valid_move) {
            printf("Invalid move. Try again.\n");
        }

        player =!player;
    }

    draw_board(board);
    printf("\nPlayer %d wins!\n", player);
}

int main() {
    srand(time(NULL));

    int board[ROWS][COLS] = {{0, 0, 0}, {0, 0, 0}, {0, 0, 0}};

    play_game(board);

    return 0;
}