//Code Llama-13B DATASET v1.0 Category: Matrix operations ; Style: realistic
/*
*  Matrix Operations Example Program in C
*  --------------------------------------
*  In this program, we will demonstrate how to perform basic matrix operations in C.
*  We will perform addition, subtraction, multiplication, and transposition.
*  --------------------------------------
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#define M 3 // Number of rows
#define N 3 // Number of columns
// Function to initialize a matrix
void init_matrix(int mat[M][N]) {
  for (int i = 0; i < M; i++) {
    for (int j = 0; j < N; j++) {
      mat[i][j] = rand() % 10 + 1;
    }
  }
}
// Function to display a matrix
void display_matrix(int mat[M][N]) {
  for (int i = 0; i < M; i++) {
    for (int j = 0; j < N; j++) {
      printf("%d ", mat[i][j]);
    }
    printf("\n");
  }
}
// Function to perform matrix addition
void add_matrices(int mat1[M][N], int mat2[M][N], int result[M][N]) {
  for (int i = 0; i < M; i++) {
    for (int j = 0; j < N; j++) {
      result[i][j] = mat1[i][j] + mat2[i][j];
    }
  }
}
// Function to perform matrix subtraction
void sub_matrices(int mat1[M][N], int mat2[M][N], int result[M][N]) {
  for (int i = 0; i < M; i++) {
    for (int j = 0; j < N; j++) {
      result[i][j] = mat1[i][j] - mat2[i][j];
    }
  }
}
// Function to perform matrix multiplication
void mul_matrices(int mat1[M][N], int mat2[M][N], int result[M][N]) {
  for (int i = 0; i < M; i++) {
    for (int j = 0; j < N; j++) {
      result[i][j] = 0;
      for (int k = 0; k < N; k++) {
        result[i][j] += mat1[i][k] * mat2[k][j];
      }
    }
  }
}
// Function to perform matrix transposition
void transpose_matrix(int mat[M][N], int result[M][N]) {
  for (int i = 0; i < M; i++) {
    for (int j = 0; j < N; j++) {
      result[i][j] = mat[j][i];
    }
  }
}
// Main function
int main() {
  // Initialize two matrices
  int mat1[M][N], mat2[M][N];
  init_matrix(mat1);
  init_matrix(mat2);
  // Display the matrices
  printf("Matrix 1:\n");
  display_matrix(mat1);
  printf("Matrix 2:\n");
  display_matrix(mat2);
  // Perform matrix operations
  int result[M][N];
  add_matrices(mat1, mat2, result);
  printf("Matrix 1 + Matrix 2:\n");
  display_matrix(result);
  sub_matrices(mat1, mat2, result);
  printf("Matrix 1 - Matrix 2:\n");
  display_matrix(result);
  mul_matrices(mat1, mat2, result);
  printf("Matrix 1 * Matrix 2:\n");
  display_matrix(result);
  transpose_matrix(mat1, result);
  printf("Transpose of Matrix 1:\n");
  display_matrix(result);
  return 0;
}