//Code Llama-13B DATASET v1.0 Category: Phone Book ; Style: interoperable
/*
 * Phone Book
 *
 * This program allows users to add, delete, and search for phone numbers in a phone book.
 *
 * Author: [Your Name]
 * Date:   [Today's Date]
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LEN 32
#define MAX_PHONE_LEN 16

typedef struct {
    char name[MAX_NAME_LEN];
    char phone[MAX_PHONE_LEN];
} PhoneBookEntry;

void add_entry(PhoneBookEntry *entries, int *count, char *name, char *phone) {
    if (*count >= MAX_PHONE_LEN) {
        printf("Phone book is full. Unable to add new entry.\n");
        return;
    }

    PhoneBookEntry *new_entry = &entries[*count];
    strcpy(new_entry->name, name);
    strcpy(new_entry->phone, phone);

    (*count)++;
}

void delete_entry(PhoneBookEntry *entries, int *count, char *name) {
    int index = -1;

    for (int i = 0; i < *count; i++) {
        if (strcmp(entries[i].name, name) == 0) {
            index = i;
            break;
        }
    }

    if (index == -1) {
        printf("Entry not found in phone book.\n");
        return;
    }

    PhoneBookEntry *last_entry = &entries[*count - 1];
    entries[index] = *last_entry;

    (*count)--;
}

void search_entry(PhoneBookEntry *entries, int count, char *name) {
    for (int i = 0; i < count; i++) {
        if (strcmp(entries[i].name, name) == 0) {
            printf("Phone number: %s\n", entries[i].phone);
            return;
        }
    }

    printf("Entry not found in phone book.\n");
}

int main() {
    PhoneBookEntry entries[MAX_PHONE_LEN];
    int count = 0;

    // Add some test entries
    add_entry(entries, &count, "John Doe", "555-1234");
    add_entry(entries, &count, "Jane Doe", "555-5678");
    add_entry(entries, &count, "Bob Smith", "555-9012");

    // Search for an entry
    search_entry(entries, count, "Bob Smith");

    // Delete an entry
    delete_entry(entries, &count, "Jane Doe");

    // Search for an entry again
    search_entry(entries, count, "Jane Doe");

    return 0;
}