//LLAMA2-13B DATASET v1.0 Category: Math exercise ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define MAGIC_CONSTANT 42

// Define a struct to hold our math problems
typedef struct {
    int num1;
    int num2;
    int op;
    int expected;
} math_problem;

// Function to print out the math problems
void print_problems(math_problem problems[], int count) {
    int i;
    for (i = 0; i < count; i++) {
        printf("%d x %d = %d\n", problems[i].num1, problems[i].num2, problems[i].expected);
    }
}

// Function to solve the math problems
int solve_problem(math_problem problem) {
    int result;
    switch (problem.op) {
        case '+':
            result = problem.num1 + problem.num2;
            break;
        case '-':
            result = problem.num1 - problem.num2;
            break;
        case '*':
            result = problem.num1 * problem.num2;
            break;
        case '/':
            result = problem.num1 / problem.num2;
            break;
        default:
            result = -1;
            break;
    }
    return result;
}

int main() {
    // Define an array of math problems
    math_problem problems[] = {
        {1, 2, '+', 3},
        {4, 5, '*', 20},
        {6, 7, '/', 8},
        {9, 10, '-', 11}
    };
    int count = sizeof(problems) / sizeof(problems[0]);

    // Print out the math problems
    print_problems(problems, count);

    // Solve each problem and print the results
    int i;
    for (i = 0; i < count; i++) {
        int result = solve_problem(problems[i]);
        if (result != -1) {
            printf("%d is correct\n", result);
        } else {
            printf("%d is incorrect\n", result);
        }
    }

    return 0;
}