//GEMINI-pro DATASET v1.0 Category: Networking ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
    // Let's set up our very own secret rendezvous point, a place where spies can exchange whispers and plots.
    // We'll use a socket, a secret tunnel that connects two computers through the vast expanse of the Internet.
    int rendezvous_socket = socket(AF_INET, SOCK_STREAM, 0);
    if (rendezvous_socket == -1) {
        perror("Couldn't establish our secret rendezvous point.");
        return -1;
    }

    // Now we need to specify where our rendezvous point will be located in the vast expanse of the Internet.
    // We'll use a rendezvous_address, a unique identifier that pinpoints our meeting spot.
    struct sockaddr_in rendezvous_address;
    rendezvous_address.sin_family = AF_INET;
    rendezvous_address.sin_port = htons(8080);
    rendezvous_address.sin_addr.s_addr = inet_addr("127.0.0.1");

    // With our rendezvous point set up, we now need to prepare for the arrival of our fellow spies.
    // We'll use bind() to tell the socket to listen for incoming connections on our secret rendezvous point.
    if (bind(rendezvous_socket, (struct sockaddr *)&rendezvous_address, sizeof(rendezvous_address)) == -1) {
        perror("Couldn't prepare our rendezvous point for incoming spies.");
        return -1;
    }

    // Now we wait patiently in our rendezvous point, listening for the arrival of our fellow spies.
    // We'll use listen() to switch the socket into listening mode, waiting for a spy to approach our secret meeting spot.
    if (listen(rendezvous_socket, 10) == -1) {
        perror("Couldn't switch our rendezvous point into listening mode.");
        return -1;
    }

    // Finally, our moment arrives! A spy has approached our rendezvous point.
    // We'll use accept() to retrieve the spy's connection information and welcome them into our secret meeting spot.
    struct sockaddr_in spy_address;
    int spy_socket = accept(rendezvous_socket, (struct sockaddr *)&spy_address, (socklen_t *)sizeof(spy_address));
    if (spy_socket == -1) {
        perror("Couldn't welcome our fellow spy into our secret meeting spot.");
        return -1;
    }

    // Now we can finally exchange whispers and plots with our fellow spy, secure in the knowledge that our rendezvous point is shrouded in secrecy.
    // We'll use send() to transmit our messages to the spy and recv() to receive their whispers back.
    char message[] = "Greetings, fellow spy! Welcome to our secret rendezvous point.";
    if (send(spy_socket, message, strlen(message), 0) == -1) {
        perror("Couldn't transmit our greeting to our fellow spy.");
        return -1;
    }

    char spy_message[1024];
    if (recv(spy_socket, spy_message, sizeof(spy_message), 0) == -1) {
        perror("Couldn't receive our fellow spy's whisper.");
        return -1;
    }

    // Our mission accomplished, we bid farewell to our fellow spy and close down our secret rendezvous point.
    // We'll use close() to shut down the socket and release the resources it held.
    printf("%s\n", spy_message);
    close(spy_socket);
    close(rendezvous_socket);

    return 0;
}