//GEMINI-pro DATASET v1.0 Category: Smart home automation ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Define the types of devices
typedef enum {
    LIGHT,
    AC,
    FAN,
    TV
} device_type;

// Define the states of devices
typedef enum {
    OFF,
    ON
} device_state;

// Define the structure of a device
typedef struct {
    device_type type;
    device_state state;
} device;

// Create an array of devices
device devices[] = {
    {LIGHT, OFF},
    {AC, OFF},
    {FAN, OFF},
    {TV, OFF}
};

// Function to print the status of devices
void print_status() {
    for (int i = 0; i < sizeof(devices) / sizeof(device); i++) {
        printf("Device %d: ", i);
        switch (devices[i].type) {
            case LIGHT:
                printf("Light");
                break;
            case AC:
                printf("AC");
                break;
            case FAN:
                printf("Fan");
                break;
            case TV:
                printf("TV");
                break;
        }
        printf(" is ");
        switch (devices[i].state) {
            case OFF:
                printf("off\n");
                break;
            case ON:
                printf("on\n");
                break;
        }
    }
}

// Function to change the state of a device
void change_state(int device_index, device_state new_state) {
    if (device_index >= 0 && device_index < sizeof(devices) / sizeof(device)) {
        devices[device_index].state = new_state;
    }
}

// Main function
int main() {
    // Print the initial status of devices
    printf("Initial status of devices:\n");
    print_status();

    // Change the state of some devices
    change_state(0, ON);  // Turn on the light
    change_state(1, ON);  // Turn on the AC
    change_state(3, ON);  // Turn on the TV

    // Print the updated status of devices
    printf("\nUpdated status of devices:\n");
    print_status();

    return 0;
}