//GPT-4o-mini DATASET v1.0 Category: Random Conspiracy Theory Generator ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define MAX_THEORIES 10
#define MAX_FACTS 20
#define MAX_STR_LENGTH 256

// Struct to hold conspiracy theory components
typedef struct {
    char theory[MAX_STR_LENGTH];
    char related_fact[MAX_STR_LENGTH];
} ConspiracyTheory;

// A function to generate a random conspiracy theory
void generateConspiracyTheory(ConspiracyTheory *theories, int n) {
    srand(time(NULL)); // Seed random number generator

    // Generate random conspiracy theories
    for (int i = 0; i < n; i++) {
        snprintf(theories[i].theory, MAX_STR_LENGTH,
                 "The moon landing was staged %d years ago to cover up the real invasion from alien beings.",
                 rand() % 50);

        snprintf(theories[i].related_fact, MAX_STR_LENGTH,
                 "Coincidentally, there were reports of sightings of UFOs %d days before the landing.",
                 rand() % 365);
    }
}

// A function to display the conspiracy theories
void displayConspiracyTheories(ConspiracyTheory *theories, int n) {
    for (int i = 0; i < n; i++) {
        printf("Theory %d: %s\n", i + 1, theories[i].theory);
        printf("Related Fact: %s\n", theories[i].related_fact);
        printf("\n");
    }
}

// Function to pick a random conspiracy theory out of the generated theories
void randomTheory(ConspiracyTheory *theories, int n) {
    int random_index = rand() % n;
    printf("Random Conspiracy Theory:\n");
    printf("Theory: %s\n", theories[random_index].theory);
    printf("Related Fact: %s\n", theories[random_index].related_fact);
}

// Main function where execution starts
int main() {
    ConspiracyTheory theories[MAX_THEORIES];
    char *titles[MAX_FACTS] = {
        "Bigfoot is Real", "Aliens Control Our Minds", 
        "The Earth is Hollow", "Lizard People Rule the World", 
        "The Titanic Never Sank", "COVID-19 is a Government Plot", 
        "Chemtrails are Poison", "Reptilian Overlords Have Arrived", 
        "The Bermuda Triangle is a Portal", "The Simpsons Predict the Future"
    };
    char *details[MAX_FACTS] = {
        "Every time Bigfoot is reported, the government denies it furthers the cover-up.",
        "Mind control is achieved by implanting chips in fast food.",
        "The center of the Earth contains entire civilizations.",
        "Many celebrities are actually lizard people in disguise.",
        "The Titanic was switched with another ship to hide evidence!",
        "By creating chaos, governments can control people.",
        "Chemicals released for 'weather control' actually alter perceptions.",
        "They’ve infiltrated politics and entertainment.",
        "Disappearance and reappearances of planes hint at time travel.",
        "The show 'The Simpsons' has predicted all major events, hinting at time loops."
    };

    // Adding some creative flair to the theories
    for (int i = 0; i < MAX_THEORIES; i++) {
        snprintf(theories[i].theory, MAX_STR_LENGTH, "%s - %s", titles[i % MAX_FACTS], details[i % MAX_FACTS]);
        snprintf(theories[i].related_fact, MAX_STR_LENGTH, 
                 "Related: Listen closely to the news after %d PM, they hide the truth.",
                 rand() % 24);
    }

    // Display all generated theories
    displayConspiracyTheories(theories, MAX_THEORIES);

    // Display a random conspiracy theory
    randomTheory(theories, MAX_THEORIES);

    return 0;
}