//MISTRAL-7B DATASET v1.0 Category: Alien Invasion Probability Calculator ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_PLANETS 10
#define NUM_ALIENS 50
#define NUM_SIGNALS 10
#define MIN_LIFE_YEARS 100
#define MAX_LIFE_YEARS 1000
#define MIN_SIGNAL_FREQUENCY 10
#define MAX_SIGNAL_FREQUENCY 100
#define MIN_SIGNAL_DURATION 1
#define MAX_SIGNAL_DURATION 10

typedef struct {
    int id;
    int life_years;
    int signal_frequency;
    int signal_duration;
} planet_t;

void generate_planets(planet_t planets[NUM_PLANETS]) {
    for (int i = 0; i < NUM_PLANETS; i++) {
        planets[i].id = i + 1;
        planets[i].life_years = rand() % (MAX_LIFE_YEARS - MIN_LIFE_YEARS + 1) + MIN_LIFE_YEARS;
        planets[i].signal_frequency = rand() % (MAX_SIGNAL_FREQUENCY - MIN_SIGNAL_FREQUENCY + 1) + MIN_SIGNAL_FREQUENCY;
        planets[i].signal_duration = rand() % (MAX_SIGNAL_DURATION - MIN_SIGNAL_DURATION + 1) + MIN_SIGNAL_DURATION;
    }
}

int calculate_alien_invasion_probability(planet_t planets[NUM_PLANETS], int num_signals, int* signals) {
    int num_matches = 0;
    for (int i = 0; i < num_signals; i++) {
        for (int j = 0; j < NUM_PLANETS; j++) {
            if (signals[i] >= planets[j].signal_frequency && signals[i] <= planets[j].signal_frequency + planets[j].signal_duration) {
                num_matches++;
                break;
            }
        }
    }
    return num_matches * 100 / num_signals;
}

int main() {
    srand(time(NULL));
    planet_t planets[NUM_PLANETS];
    int signals[NUM_SIGNALS][2];
    int num_signals = NUM_SIGNALS;

    generate_planets(planets);

    printf("Planets:\n");
    for (int i = 0; i < NUM_PLANETS; i++) {
        printf("Planet %d: %d years, %d Hz, %d Hz\n", planets[i].id, planets[i].life_years, planets[i].signal_frequency, planets[i].signal_duration);
    }

    printf("\nSignals:\n");
    for (int i = 0; i < num_signals; i++) {
        signals[i][0] = rand() % (MAX_SIGNAL_FREQUENCY - MIN_SIGNAL_FREQUENCY + 1) + MIN_SIGNAL_FREQUENCY;
        signals[i][1] = rand() % (MAX_SIGNAL_DURATION - MIN_SIGNAL_DURATION + 1) + MIN_SIGNAL_DURATION;
        printf("Signal %d: %d Hz, %d Hz\n", i + 1, signals[i][0], signals[i][1]);
    }

    int invasion_probability = calculate_alien_invasion_probability(planets, num_signals, signals);
    printf("\nAlien Invasion Probability: %d%%\n", invasion_probability);

    return 0;
}