//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>

#define SHM_SIZE 1024

// Create a shared memory segment
int create_shm(key_t key) {
    int shmid = shmget(key, SHM_SIZE, IPC_CREAT | IPC_EXCL | 0666);
    if (shmid == -1) {
        perror("shmget");
        exit(EXIT_FAILURE);
    }
    return shmid;
}

// Attach the shared memory segment to the current process
void* attach_shm(int shmid) {
    void* shmaddr = shmat(shmid, NULL, 0);
    if (shmaddr == (void*)-1) {
        perror("shmat");
        exit(EXIT_FAILURE);
    }
    return shmaddr;
}

// Detach the shared memory segment from the current process
void detach_shm(void* shmaddr) {
    if (shmdt(shmaddr) == -1) {
        perror("shmdt");
        exit(EXIT_FAILURE);
    }
}

// Remove the shared memory segment
void remove_shm(int shmid) {
    if (shmctl(shmid, IPC_RMID, NULL) == -1) {
        perror("shmctl");
        exit(EXIT_FAILURE);
    }
}

// Create a semaphore set
int create_sem(key_t key) {
    int semid = semget(key, 1, IPC_CREAT | IPC_EXCL | 0666);
    if (semid == -1) {
        perror("semget");
        exit(EXIT_FAILURE);
    }
    return semid;
}

// Initialize the semaphore set
void init_sem(int semid, int value) {
    if (semctl(semid, 0, SETVAL, value) == -1) {
        perror("semctl");
        exit(EXIT_FAILURE);
    }
}

// Lock the semaphore
void lock_sem(int semid) {
    struct sembuf sops = {0, -1, 0};
    if (semop(semid, &sops, 1) == -1) {
        perror("semop");
        exit(EXIT_FAILURE);
    }
}

// Unlock the semaphore
void unlock_sem(int semid) {
    struct sembuf sops = {0, 1, 0};
    if (semop(semid, &sops, 1) == -1) {
        perror("semop");
        exit(EXIT_FAILURE);
    }
}

// Remove the semaphore set
void remove_sem(int semid) {
    if (semctl(semid, 0, IPC_RMID, NULL) == -1) {
        perror("semctl");
        exit(EXIT_FAILURE);
    }
}

int main() {
    // Create a unique key for the shared memory segment and semaphore set
    key_t key = ftok(".", 'a');

    // Create the shared memory segment
    int shmid = create_shm(key);

    // Attach the shared memory segment to the current process
    void* shmaddr = attach_shm(shmid);

    // Create the semaphore set
    int semid = create_sem(key);

    // Initialize the semaphore set
    init_sem(semid, 1);

    // Write to the shared memory segment
    lock_sem(semid);
    sprintf(shmaddr, "Hello, world!");
    unlock_sem(semid);

    // Read from the shared memory segment
    lock_sem(semid);
    printf("Shared memory: %s\n", shmaddr);
    unlock_sem(semid);

    // Detach the shared memory segment from the current process
    detach_shm(shmaddr);

    // Remove the shared memory segment and semaphore set
    remove_shm(shmid);
    remove_sem(semid);

    return 0;
}