//GEMINI-pro DATASET v1.0 Category: Arithmetic ; Style: surprised
// Behold, a tale of arithmetic awe and wonder!

#include <stdio.h>

int main() {
    // A myriad of variables, each with a purpose to fulfill.
    int a = 10, b = 20, c = 30;
    float x = 1.5, y = 2.5, z = 3.5;
    char ch1 = 'A', ch2 = 'B', ch3 = 'C';

    // Basic arithmetic operations, the foundation of calculations.
    printf("Sum: %d\n", a + b + c);
    printf("Difference: %d\n", b - a);
    printf("Product: %d\n", a * b * c);
    printf("Quotient: %.2f\n", x / y);

    // Increment and decrement operators, the nimble manipulators.
    printf("Increment: %d\n", ++a);
    printf("Decrement: %d\n", --c);

    // Assignment operators, the backbone of variable manipulation.
    a += 10;
    b -= 5;
    c *= 2;
    printf("New values: %d, %d, %d\n", a, b, c);

    // Relational operators, the judges of comparison.
    printf("Equality: %d\n", a == b);
    printf("Inequality: %d\n", x != y);
    printf("Greater than: %d\n", c > a);

    // Conditional operators, the gatekeepers of decision-making.
    int max = (a > b) ? a : b;
    printf("Maximum: %d\n", max);

    // Bitwise operators, the masters of binary manipulation.
    int mask = 0b1111;
    printf("Bitwise AND: %d\n", a & mask);
    printf("Bitwise OR: %d\n", a | mask);
    printf("Bitwise XOR: %d\n", a ^ mask);

    // Casts, the transformers of data types.
    double d = (double)a;
    int i = (int)x;
    printf("Double of a: %.2f\n", d);
    printf("Integer of x: %d\n", i);

    // Pointer arithmetic, the art of memory navigation.
    int arr[] = {1, 2, 3};
    int *ptr = arr;
    printf("*ptr: %d\n", *ptr);
    printf("*(ptr+1): %d\n", *(ptr+1));

    // Character manipulation, the building blocks of communication.
    printf("Combined characters: %c\n", (ch1 + ch2 + ch3) / 3);
    printf("ASCII value of 'C': %d\n", ch3);

    // Expressions, the intricate sequences of computations.
    int expr = a * (b - (c / 2)) + y;
    printf("Complex expression: %d\n", expr);

    // Mathematical functions, the indispensable tools of calculation.
    printf("Sine of x: %.2f\n", sin(x));
    printf("Logarithm of y: %.2f\n", log(y));
    printf("Absolute value of z: %.2f\n", fabs(z));

    return 0;
}