//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: future-proof
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>

#define MAX_PROC 8

typedef struct Process {
  int pid;
  char name[20];
  int cpu_time;
  int waiting_time;
  int turnaround_time;
} Process;

Process processes[MAX_PROC];

void round_robin(int quantum) {
  int i = 0;
  for (int t = 0; t < quantum; t++) {
    for (i = 0; i < MAX_PROC && processes[i].cpu_time > 0; i++) {
      processes[i].cpu_time--;
    }
  }
}

void calculate_stats(Process *p) {
  p->waiting_time = processes[0].cpu_time - p->cpu_time;
  p->turnaround_time = p->waiting_time + p->cpu_time;
}

int main() {
  int i = 0;
  for (i = 0; i < MAX_PROC; i++) {
    processes[i].pid = i + 1;
    sprintf(processes[i].name, "Process %d", processes[i].pid);
    processes[i].cpu_time = rand() % 10;
  }

  round_robin(5);

  for (i = 0; i < MAX_PROC; i++) {
    calculate_stats(&processes[i]);
  }

  for (i = 0; i < MAX_PROC; i++) {
    printf("Process %s: CPU time %d, Waiting time %d, Turnaround time %d\n", processes[i].name, processes[i].cpu_time, processes[i].waiting_time, processes[i].turnaround_time);
  }

  return 0;
}