//Falcon-180B DATASET v1.0 Category: Banking Record System ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ACCOUNTS 100
#define MAX_NAME_LENGTH 50
#define MAX_ACCOUNT_NUMBER_LENGTH 10

typedef struct {
    char name[MAX_NAME_LENGTH];
    char accountNumber[MAX_ACCOUNT_NUMBER_LENGTH];
    double balance;
} Account;

Account accounts[MAX_ACCOUNTS];
int numAccounts = 0;

void addAccount(char* name, char* accountNumber, double initialBalance) {
    strcpy(accounts[numAccounts].name, name);
    strcpy(accounts[numAccounts].accountNumber, accountNumber);
    accounts[numAccounts].balance = initialBalance;
    numAccounts++;
}

int findAccount(char* accountNumber) {
    for (int i = 0; i < numAccounts; i++) {
        if (strcmp(accounts[i].accountNumber, accountNumber) == 0) {
            return i;
        }
    }
    return -1;
}

void deposit(char* accountNumber, double amount) {
    int accountIndex = findAccount(accountNumber);
    if (accountIndex == -1) {
        printf("Account not found.\n");
        return;
    }
    accounts[accountIndex].balance += amount;
    printf("Deposit successful.\n");
}

void withdraw(char* accountNumber, double amount) {
    int accountIndex = findAccount(accountNumber);
    if (accountIndex == -1) {
        printf("Account not found.\n");
        return;
    }
    if (accounts[accountIndex].balance < amount) {
        printf("Insufficient balance.\n");
        return;
    }
    accounts[accountIndex].balance -= amount;
    printf("Withdrawal successful.\n");
}

void checkBalance(char* accountNumber) {
    int accountIndex = findAccount(accountNumber);
    if (accountIndex == -1) {
        printf("Account not found.\n");
        return;
    }
    printf("Balance: $%.2f\n", accounts[accountIndex].balance);
}

int main() {
    // Example usage
    addAccount("John Doe", "123456789", 1000.00);
    addAccount("Jane Doe", "987654321", 500.00);

    deposit("123456789", 200.00);
    withdraw("987654321", 50.00);

    checkBalance("123456789");
    checkBalance("987654321");

    return 0;
}