//GEMINI-pro DATASET v1.0 Category: Procedurally Generated Maze ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the maze dimensions
#define MAZE_WIDTH 21
#define MAZE_HEIGHT 21

// Define the cell types
#define CELL_EMPTY 0
#define CELL_WALL 1
#define CELL_VISITED 2

// Define the directions
#define DIR_NORTH 0
#define DIR_EAST 1
#define DIR_SOUTH 2
#define DIR_WEST 3

// Create the maze data structure
int maze[MAZE_HEIGHT][MAZE_WIDTH];

// Create a stack to store the visited cells
int stack[MAZE_HEIGHT * MAZE_WIDTH];
int stack_top = -1;

// Function to push a cell onto the stack
void push(int x, int y) {
  stack[++stack_top] = x * MAZE_WIDTH + y;
}

// Function to pop a cell from the stack
void pop(int *x, int *y) {
  int index = stack[stack_top--];
  *x = index / MAZE_WIDTH;
  *y = index % MAZE_WIDTH;
}

// Function to check if a cell is valid
int is_valid(int x, int y) {
  return x >= 0 && x < MAZE_HEIGHT && y >= 0 && y < MAZE_WIDTH && maze[x][y] == CELL_EMPTY;
}

// Function to generate the maze
void generate_maze() {
  // Initialize the maze
  for (int i = 0; i < MAZE_HEIGHT; i++) {
    for (int j = 0; j < MAZE_WIDTH; j++) {
      maze[i][j] = CELL_WALL;
    }
  }

  // Set the starting cell
  int x = 0;
  int y = 0;
  maze[x][y] = CELL_EMPTY;

  // Push the starting cell onto the stack
  push(x, y);

  // While the stack is not empty
  while (stack_top >= 0) {
    // Pop the current cell from the stack
    pop(&x, &y);

    // Mark the current cell as visited
    maze[x][y] = CELL_VISITED;

    // Get a random direction
    int direction = rand() % 4;

    // Try to move in the random direction
    int new_x = x;
    int new_y = y;
    switch (direction) {
      case DIR_NORTH:
        new_x--;
        break;
      case DIR_EAST:
        new_y++;
        break;
      case DIR_SOUTH:
        new_x++;
        break;
      case DIR_WEST:
        new_y--;
        break;
    }

    // If the new cell is valid, move to it
    if (is_valid(new_x, new_y)) {
      maze[new_x][new_y] = CELL_EMPTY;
      push(new_x, new_y);
    }
  }
}

// Function to print the maze
void print_maze() {
  for (int i = 0; i < MAZE_HEIGHT; i++) {
    for (int j = 0; j < MAZE_WIDTH; j++) {
      if (maze[i][j] == CELL_WALL) {
        printf("#");
      } else {
        printf(" ");
      }
    }
    printf("\n");
  }
}

int main() {
  // Seed the random number generator
  srand(time(NULL));

  // Generate the maze
  generate_maze();

  // Print the maze
  print_maze();

  return 0;
}