//Falcon-180B DATASET v1.0 Category: Personal Finance Planner ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100

typedef struct {
    char name[50];
    float price;
    int quantity;
} item_t;

void add_item(item_t *items, int count, char *name, float price, int quantity) {
    if (count >= MAX_ITEMS) {
        printf("Error: maximum number of items reached.\n");
        return;
    }

    strcpy(items[count].name, name);
    items[count].price = price;
    items[count].quantity = quantity;

    printf("Item added: %s - $%.2f - %d\n", items[count].name, items[count].price, items[count].quantity);
}

void display_items(item_t *items, int count) {
    printf("\nItems:\n");
    for (int i = 0; i < count; i++) {
        printf("%s - $%.2f - %d\n", items[i].name, items[i].price, items[i].quantity);
    }
}

void calculate_total(item_t *items, int count) {
    float total = 0.0;

    printf("\nTotal: $%.2f\n", total);

    for (int i = 0; i < count; i++) {
        total += items[i].price * items[i].quantity;
    }

    printf("Total: $%.2f\n", total);
}

int main() {
    item_t items[MAX_ITEMS];
    int count = 0;

    add_item(items, count, "Laptop", 1000.00, 1);
    add_item(items, count, "Phone", 500.00, 2);
    add_item(items, count, "Tablet", 300.00, 3);

    display_items(items, count);
    calculate_total(items, count);

    return 0;
}