//GEMINI-pro DATASET v1.0 Category: Word Frequency Counter ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_WORDS 10000
#define MAX_WORD_LENGTH 100

typedef struct {
    char *word;
    int count;
} WordCount;

int compareWords(const void *a, const void *b) {
    WordCount *wa = (WordCount *)a;
    WordCount *wb = (WordCount *)b;
    return strcmp(wa->word, wb->word);
}

int main() {
    // Read the input text
    char *text = NULL;
    size_t len = 0;
    getline(&text, &len, stdin);

    // Tokenize the text into words
    char *token = strtok(text, " ");
    WordCount words[MAX_WORDS];
    int numWords = 0;
    while (token != NULL) {
        // Check if the word is already in the list
        int found = 0;
        for (int i = 0; i < numWords; i++) {
            if (strcmp(token, words[i].word) == 0) {
                words[i].count++;
                found = 1;
                break;
            }
        }

        // If the word is not in the list, add it
        if (!found) {
            words[numWords].word = strdup(token);
            words[numWords].count = 1;
            numWords++;
        }

        // Get the next token
        token = strtok(NULL, " ");
    }

    // Sort the words by frequency
    qsort(words, numWords, sizeof(WordCount), compareWords);

    // Print the word frequencies
    for (int i = 0; i < numWords; i++) {
        printf("%s: %d\n", words[i].word, words[i].count);
    }

    // Free the allocated memory
    for (int i = 0; i < numWords; i++) {
        free(words[i].word);
    }
    free(text);

    return 0;
}