//GEMINI-pro DATASET v1.0 Category: Hotel Management System ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

#define MAX_PLAYERS 4
#define MAX_ROOMS 10

typedef struct {
    int id;
    char name[32];
    int room;
} Player;

typedef struct {
    int id;
    char name[32];
} Room;

Player players[MAX_PLAYERS];
Room rooms[MAX_ROOMS];
int num_players = 0;
int num_rooms = 0;

pthread_mutex_t lock;

void create_room(char *name) {
    pthread_mutex_lock(&lock);

    if (num_rooms >= MAX_ROOMS) {
        printf("Error: Maximum number of rooms reached\n");
        pthread_mutex_unlock(&lock);
        return;
    }

    Room *room = &rooms[num_rooms++];

    strcpy(room->name, name);
    room->id = num_rooms;

    pthread_mutex_unlock(&lock);
}

void join_room(int player_id, int room_id) {
    pthread_mutex_lock(&lock);

    if (room_id < 0 || room_id >= num_rooms) {
        printf("Error: Invalid room ID\n");
        pthread_mutex_unlock(&lock);
        return;
    }

    Room *room = &rooms[room_id];

    if (room->id == -1) {
        printf("Error: Room not found\n");
        pthread_mutex_unlock(&lock);
        return;
    }

    players[player_id].room = room_id;

    printf("%s joined room %s\n", players[player_id].name, room->name);

    pthread_mutex_unlock(&lock);
}

void leave_room(int player_id) {
    pthread_mutex_lock(&lock);

    Room *room = &rooms[players[player_id].room];

    if (room->id == -1) {
        printf("Error: Player not in a room\n");
        pthread_mutex_unlock(&lock);
        return;
    }

    printf("%s left room %s\n", players[player_id].name, room->name);

    players[player_id].room = -1;

    pthread_mutex_unlock(&lock);
}

void send_message(int player_id, char *message) {
    pthread_mutex_lock(&lock);

    Room *room = &rooms[players[player_id].room];

    if (room->id == -1) {
        printf("Error: Player not in a room\n");
        pthread_mutex_unlock(&lock);
        return;
    }

    for (int i = 0; i < num_players; i++) {
        if (players[i].room == room->id) {
            printf("%s: %s\n", players[i].name, message);
        }
    }

    pthread_mutex_unlock(&lock);
}

void *player_thread(void *arg) {
    int player_id = (int)arg;

    while (1) {
        char command[32];

        printf("Enter a command (create_room, join_room, leave_room, send_message, quit): ");
        scanf("%s", command);

        if (strcmp(command, "create_room") == 0) {
            char name[32];

            printf("Enter a room name: ");
            scanf("%s", name);

            create_room(name);
        } else if (strcmp(command, "join_room") == 0) {
            int room_id;

            printf("Enter a room ID: ");
            scanf("%d", &room_id);

            join_room(player_id, room_id);
        } else if (strcmp(command, "leave_room") == 0) {
            leave_room(player_id);
        } else if (strcmp(command, "send_message") == 0) {
            char message[128];

            printf("Enter a message: ");
            scanf(" %[^\n]s", message);

            send_message(player_id, message);
        } else if (strcmp(command, "quit") == 0) {
            break;
        }
    }

    return NULL;
}

int main() {
    pthread_t threads[MAX_PLAYERS];

    for (int i = 0; i < num_players; i++) {
        char name[32];

        printf("Enter a player name: ");
        scanf("%s", name);

        strcpy(players[i].name, name);
        players[i].id = i;
        players[i].room = -1;

        pthread_create(&threads[i], NULL, player_thread, (void *)i);
    }

    for (int i = 0; i < num_players; i++) {
        pthread_join(threads[i], NULL);
    }

    return 0;
}