//GPT-4o-mini DATASET v1.0 Category: Modern Encryption ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/aes.h>
#include <openssl/rand.h>

#define AES_KEY_SIZE 128
#define BLOCK_SIZE 16

void handleErrors() {
    ERR_print_errors_fp(stderr);
    abort();
}

void generate_key(unsigned char *key, int size) {
    if (!RAND_bytes(key, size)) {
        handleErrors();
    }
}

void encrypt(unsigned char *in, unsigned char *out, unsigned char *key) {
    AES_KEY encryptKey;
    if (AES_set_encrypt_key(key, AES_KEY_SIZE, &encryptKey) < 0) {
        handleErrors();
    }
    AES_encrypt(in, out, &encryptKey);
}

void decrypt(unsigned char *in, unsigned char *out, unsigned char *key) {
    AES_KEY decryptKey;
    if (AES_set_decrypt_key(key, AES_KEY_SIZE, &decryptKey) < 0) {
        handleErrors();
    }
    AES_decrypt(in, out, &decryptKey);
}

void print_hex(const char *label, unsigned char *data, size_t size) {
    printf("%s: ", label);
    for (size_t i = 0; i < size; i++) {
        printf("%02x ", data[i]);
    }
    printf("\n");
}

void input_data(unsigned char *data, size_t size) {
    printf("Enter data to encrypt (max %zu characters): ", size - 1);
    fgets((char *)data, size, stdin);
    data[strcspn((char *)data, "\n")] = 0; // Remove newline character
}

int main() {
    unsigned char key[AES_KEY_SIZE / 8]; // Key size in bytes
    unsigned char input[BLOCK_SIZE]; // Input block
    unsigned char encrypted[BLOCK_SIZE]; // Encrypted block
    unsigned char decrypted[BLOCK_SIZE]; // Decrypted block

    generate_key(key, sizeof(key));
    
    printf("Randomly Generated AES Key:\n");
    print_hex("Key", key, sizeof(key));

    input_data(input, sizeof(input));
    printf("Input Data: %s\n", input);

    encrypt(input, encrypted, key);
    print_hex("Encrypted Data", encrypted, sizeof(encrypted));

    decrypt(encrypted, decrypted, key);
    printf("Decrypted Data: %s\n", decrypted);

    return 0;
}