//Falcon-180B DATASET v1.0 Category: Error handling ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ERRORS 10

typedef struct {
    char *message;
    int line;
    int column;
} Error;

int error_count = 0;
Error errors[MAX_ERRORS];

void add_error(char *message, int line, int column) {
    if (error_count >= MAX_ERRORS) {
        fprintf(stderr, "Too many errors, exiting...\n");
        exit(1);
    }

    errors[error_count].message = strdup(message);
    errors[error_count].line = line;
    errors[error_count].column = column;

    error_count++;
}

void print_errors() {
    if (error_count == 0) {
        printf("No errors found.\n");
        return;
    }

    printf("Found %d errors:\n", error_count);
    for (int i = 0; i < error_count; i++) {
        printf("  Line %d, column %d: %s\n", errors[i].line, errors[i].column, errors[i].message);
    }
}

int main() {
    char *input = "int main() {\n\tsprintf(\"Hello, world!\");\n\treturn 0;\n}\n";
    int line = 1;
    int column = 1;

    while (*input) {
        if (*input == '\n') {
            line++;
            column = 1;
        } else if (column == 6) {
            if (strcmp(input, "printf") == 0) {
                add_error("Invalid use of printf", line, column);
            }
        } else if (column == 14) {
            if (strcmp(input, "return") == 0) {
                add_error("Invalid use of return", line, column);
            }
        }

        column++;
        input++;
    }

    print_errors();

    return 0;
}