//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Function to count the number of set bits in an integer
int count_set_bits(unsigned int n) {
    int count = 0;
    while (n!= 0) {
        if (n & 1) {
            count++;
        }
        n >>= 1;
    }
    return count;
}

// Function to set the nth bit of an integer
void set_bit(unsigned int *num, int n) {
    *num |= (1 << n);
}

// Function to clear the nth bit of an integer
void clear_bit(unsigned int *num, int n) {
    *num &= ~(1 << n);
}

// Function to toggle the nth bit of an integer
void toggle_bit(unsigned int *num, int n) {
    *num ^= (1 << n);
}

// Function to check if the nth bit of an integer is set
bool check_bit(unsigned int num, int n) {
    return (num & (1 << n))!= 0;
}

int main() {
    unsigned int num = 0b11001100; // Example integer with set and unset bits
    int n = 3; // Bit position to manipulate

    // Count the number of set bits in the integer
    int set_bits = count_set_bits(num);
    printf("Number of set bits: %d\n", set_bits);

    // Set the nth bit of the integer
    set_bit(&num, n);
    printf("Integer after setting bit %d: %u\n", n, num);

    // Clear the nth bit of the integer
    clear_bit(&num, n);
    printf("Integer after clearing bit %d: %u\n", n, num);

    // Toggle the nth bit of the integer
    toggle_bit(&num, n);
    printf("Integer after toggling bit %d: %u\n", n, num);

    // Check if the nth bit of the integer is set
    if (check_bit(num, n)) {
        printf("Bit %d is set\n", n);
    } else {
        printf("Bit %d is not set\n", n);
    }

    return 0;
}