//MISTRAL-7B DATASET v1.0 Category: Building a FTP Client ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <curl/curl.h>

#define FTP_PORT 21
#define BUFFER_SIZE 1024
#define USERNAME "username"
#define PASSWORD "password"

void print_error(CURLcode res) {
    if (res == CURLE_OK) return;

    fprintf(stderr, "curl_easy_setopt() failed: %s\n",
            curl_easy_strerror(res));
}

size_t write_data(void *ptr, size_t size, size_t nmemb, FILE *stream) {
    size_t written = fwrite(ptr, size, nmemb, stream);
    return written;
}

int main(void) {
    int sockfd;
    struct sockaddr_in server_addr;
    CURL *curl;
    FILE *fp;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if (curl) {
        memset(&server_addr, 0, sizeof(server_addr));
        server_addr.sin_family = AF_INET;
        inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);
        server_addr.sin_port = htons(FTP_PORT);

        sockfd = socket(AF_INET, SOCK_STREAM, 0);
        connect(sockfd, (struct sockaddr *) &server_addr, sizeof(server_addr));

        curl_easy_setopt(curl, CURLOPT_URL, "ftp://127.0.0.1");
        curl_easy_setopt(curl, CURLOPT_USERPWD, USERNAME ":" PASSWORD);
        curl_easy_setopt(curl, CURLOPT_TCP_NODELAY, 1L);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_data);

        fp = fopen("test.txt", "wb");
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, fp);

        CURLcode res = curl_easy_perform(curl);
        print_error(res);

        fclose(fp);
        curl_easy_cleanup(curl);
        close(sockfd);
    }

    curl_global_cleanup();

    return 0;
}