//GEMINI-pro DATASET v1.0 Category: Graph Coloring Problem ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the number of colors and vertices
#define COLORS 3
#define VERTICES 6

// Define the adjacency matrix
int adj_matrix[VERTICES][VERTICES] = {
    {0, 1, 1, 0, 0, 0},
    {1, 0, 1, 1, 0, 0},
    {1, 1, 0, 1, 1, 0},
    {0, 1, 1, 0, 1, 1},
    {0, 0, 1, 1, 0, 1},
    {0, 0, 0, 1, 1, 0}
};

// Define the color array
int colors[VERTICES];

// Function to check if the graph is colorable
int is_colorable() {
    // Initialize the color array
    for (int i = 0; i < VERTICES; i++) {
        colors[i] = -1;
    }

    // Iterate over the vertices
    for (int i = 0; i < VERTICES; i++) {
        // If the vertex is not colored, try to color it
        if (colors[i] == -1) {
            // Iterate over the colors
            for (int j = 0; j < COLORS; j++) {
                // Check if the color is valid
                int valid = 1;
                for (int k = 0; k < VERTICES; k++) {
                    // If the adjacent vertex is colored with the same color, the color is not valid
                    if (adj_matrix[i][k] == 1 && colors[k] == j) {
                        valid = 0;
                        break;
                    }
                }

                // If the color is valid, assign it to the vertex
                if (valid) {
                    colors[i] = j;
                    break;
                }
            }

            // If the vertex cannot be colored, the graph is not colorable
            if (colors[i] == -1) {
                return 0;
            }
        }
    }

    // If all vertices are colored, the graph is colorable
    return 1;
}

// Function to print the colors of the graph
void print_colors() {
    printf("Colors of the graph:\n");
    for (int i = 0; i < VERTICES; i++) {
        printf("Vertex %d: %d\n", i, colors[i]);
    }
}

// Main function
int main() {
    // Check if the graph is colorable
    if (is_colorable()) {
        // Print the colors of the graph
        print_colors();
    } else {
        printf("The graph is not colorable.\n");
    }

    return 0;
}