//Falcon2-11B DATASET v1.0 Category: Password Strength Checker ; Style: calm
#include <stdio.h>
#include <string.h>
#include <stdbool.h>

// Function to check password strength
bool checkPasswordStrength(char* password) {
    int length = strlen(password);
    
    // Check for minimum length
    if (length < 8) {
        printf("Password is too short\n");
        return false;
    }
    
    // Check for at least one uppercase letter
    if (strchr("A-Z", password[0]) == NULL) {
        printf("Password should contain at least one uppercase letter\n");
        return false;
    }
    
    // Check for at least one lowercase letter
    if (strchr("a-z", password[0]) == NULL) {
        printf("Password should contain at least one lowercase letter\n");
        return false;
    }
    
    // Check for at least one digit
    if (strchr("0-9", password[0]) == NULL) {
        printf("Password should contain at least one digit\n");
        return false;
    }
    
    // Check for at least one special character
    if (strchr("!@#$%^&*()_+-=[]{}|;:'\",.<>/?~`", password[0]) == NULL) {
        printf("Password should contain at least one special character\n");
        return false;
    }
    
    // Check for uniqueness
    if (strstr(password, password + 1)!= NULL) {
        printf("Password is not unique\n");
        return false;
    }
    
    // Password is strong
    return true;
}

int main() {
    char* password = "MyP@ssw0rd!";
    if (checkPasswordStrength(password)) {
        printf("Password is strong\n");
    } else {
        printf("Password is weak\n");
    }
    return 0;
}