//Falcon-180B DATASET v1.0 Category: Temperature monitor ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define PI 3.14159265358979323846
#define MAX_TEMPERATURES 100

struct temperature_data {
    float temperature;
    float humidity;
    float pressure;
    int timestamp;
};

struct temperature_data temperatures[MAX_TEMPERATURES];
int temperature_index = 0;

void add_temperature(float t, float h, float p) {
    if (temperature_index >= MAX_TEMPERATURES) {
        printf("Temperature buffer full!\n");
        return;
    }
    temperatures[temperature_index].temperature = t;
    temperatures[temperature_index].humidity = h;
    temperatures[temperature_index].pressure = p;
    temperatures[temperature_index].timestamp = time(NULL);
    temperature_index++;
}

void print_temperatures() {
    printf("Temperature Data:\n");
    printf("-----------------\n");
    printf("Index\tTemperature (C)\tHumidity (%)\tPressure (hPa)\tTimestamp\n");
    for (int i = 0; i < temperature_index; i++) {
        printf("%d\t%.2f\t%.2f\t%.2f\t%d\n", i, temperatures[i].temperature, temperatures[i].humidity, temperatures[i].pressure, temperatures[i].timestamp);
    }
}

void calculate_average_temperature() {
    float sum = 0;
    int count = 0;
    for (int i = 0; i < temperature_index; i++) {
        sum += temperatures[i].temperature;
        count++;
    }
    printf("Average Temperature: %.2f C\n", sum / count);
}

int main() {
    add_temperature(20.5, 60, 1013);
    add_temperature(21.2, 55, 1012);
    add_temperature(19.8, 65, 1011);
    print_temperatures();
    calculate_average_temperature();
    return 0;
}