//GEMINI-pro DATASET v1.0 Category: Network Packet Monitoring ; Style: Sherlock Holmes
#include <stdio.h>
#include <pcap.h>

// A display function for Sherlock Holmes-style packet inspection
void sherlock_inspect(u_char *user, const struct pcap_pkthdr *pkthdr, const u_char *packet)
{
    // Deduce the elemental properties of the packet
    int ether_proto = *packet++;
    int ip_proto = *packet++;

    printf("Case File: Packets Received\n");
    printf("----------------------------\n");

    // Examine the Ethernet layer
    printf("Ethernet:\n");
    printf("  |- Source MAC: ");
    for (int i = 0; i < 6; i++)
        printf("%02x:", packet[i]);
    printf("\n");

    printf("  |- Destination MAC: ");
    for (int i = 0; i < 6; i++)
        printf("%02x:", packet[i+6]);
    printf("\n");

    printf("  |- Protocol: ");
    switch (ether_proto)
    {
        case 0x0800: printf("IPv4"); break;
        case 0x0806: printf("ARP"); break;
        default: printf("Unknown (%04x)", ether_proto); break;
    }
    printf("\n");

    // Deduce the IP layer details
    if (ether_proto == 0x0800)
    {
        printf("IP:\n");
        printf("  |- Source IP: %u.%u.%u.%u\n",
            packet[12], packet[13], packet[14], packet[15]);
        printf("  |- Destination IP: %u.%u.%u.%u\n",
            packet[16], packet[17], packet[18], packet[19]);

        // Decipher the payload protocol
        switch (ip_proto)
        {
            case 1: printf("  |- Protocol: ICMP"); break;
            case 6: printf("  |- Protocol: TCP"); break;
            case 17: printf("  |- Protocol: UDP"); break;
            default: printf("  |- Protocol: Unknown (%d)", ip_proto); break;
        }
        printf("\n");
    }
}

int main()
{
    // Acquire the network interface for investigation
    char *dev = pcap_lookupdev(NULL);
    if (dev == NULL)
    {
        printf("The fog obscures our path... no network interface found.");
        return 1;
    }

    // Set up the network capture apparatus
    pcap_t *handle = pcap_open_live(dev, BUFSIZ, 1, 1000, NULL);
    if (handle == NULL)
    {
        printf("Our inquiries have been thwarted... unable to capture packets.");
        return 1;
    }

    // Commence the packet monitoring, my dear Watson
    pcap_loop(handle, 0, sherlock_inspect, NULL);

    // Close the case file
    pcap_close(handle);
    return 0;
}