//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define ROW 5
#define COL 5

// Function prototypes
bool isSafe(int maze[ROW][COL], int x, int y);
bool mazeSolver(int maze[ROW][COL], int x, int y, int solution[ROW][COL]);

// Function to print the solution
void printSolution(int solution[ROW][COL]) {
    printf("Solution path through the maze:\n");
    for (int i = 0; i < ROW; i++) {
        for (int j = 0; j < COL; j++) {
            if (solution[i][j] == 1) {
                printf(" * ");
            } else {
                printf(" . ");
            }
        }
        printf("\n");
    }
}

// Function to check if x, y is a valid move
bool isSafe(int maze[ROW][COL], int x, int y) {
    return (x >= 0 && x < ROW && y >= 0 && y < COL && maze[x][y] == 1);
}

// Recursive function to find the path
bool mazeSolver(int maze[ROW][COL], int x, int y, int solution[ROW][COL]) {
    // Base case: If (x,y) is the goal position
    if (x == ROW - 1 && y == COL - 1) {
        solution[x][y] = 1;
        return true;
    }

    // Check if maze[x][y] is valid
    if (isSafe(maze, x, y)) {
        // Mark x, y as part of solution path
        solution[x][y] = 1;

        // Move forward in x direction
        if (mazeSolver(maze, x + 1, y, solution)) {
            return true;
        }

        // If moving in x direction doesn't lead to a solution
        // Then try moving down in y direction
        if (mazeSolver(maze, x, y + 1, solution)) {
            return true;
        }

        // If none of the above movements work, BACKTRACK: unmark x, y
        solution[x][y] = 0;
        return false;
    }
    return false;
}

int main() {
    int maze[ROW][COL] = {
        { 1, 0, 0, 0, 0 },
        { 1, 1, 0, 1, 0 },
        { 0, 1, 0, 0, 0 },
        { 0, 1, 1, 1, 1 },
        { 0, 0, 0, 0, 1 }
    };

    int solution[ROW][COL] = { { 0, 0, 0, 0, 0 },
                                { 0, 0, 0, 0, 0 },
                                { 0, 0, 0, 0, 0 },
                                { 0, 0, 0, 0, 0 },
                                { 0, 0, 0, 0, 0 } };

    if (!mazeSolver(maze, 0, 0, solution)) {
        printf("No solution exists!\n");
    } else {
        printSolution(solution);
    }

    return 0;
}